/**
 * Copyright (c) 2017 Bosch SoftTec GmbH All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Bosch
 * SoftTec GmbH ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Bosch SoftTec (BSOT).
 *
 * BSOT MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. BSOT SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>

/**
 * Enum specifies all the possible WrongwayDriverWarning event types.
 */
typedef NS_ENUM(NSUInteger, WDWEventType) {
    
    /// All clear. No relevant wrong way driving event detected
    WDWEventNoWDW = 1000,
    
    /// There is someone nearby driving the wrong way
    WDWEventThereIsWDW = 1001,
    
    /// You are driving the wrong way
    WDWEventIAmWDW
};

/**
 * This class represents all necessary details of the received and evaluated WDW event.
 *
 * See *HMI* *Guidelines* section in WDW-SDK documentation to find out how to display a warning to the user.
 */
@interface WDWWarning : NSObject

/**
 * The `WDWEventType` of the event.
 */
@property (nonatomic, readonly) WDWEventType eventType;

/**
 * Distance in meters from user's current location to the place where the WDW event occured
 */
@property(nonatomic, readonly) CLLocationDistance distance;

@end


